unit uVimmEditObject;

interface

uses
Vcl.Forms, Vcl.ExtCtrls, Vcl.StdCtrls, Vcl.Controls, Vcl.graphics,  Vcl.Dialogs,
Vcl.CheckLst,
Winapi.Windows, Winapi.Messages,
System.Classes, System.SysUtils,
VA508AccessibilityManager, rvimm, rCore, ORCtrls, ORDtTm, ORFn, uEditObject;

type

vEditObject = class(tEditObject)
private
  procedure loadUsers(control: TControl; const StartFrom: string; Direction, InsertAt: Integer; providerOnly: boolean);

protected
  procedure onNeedData(sender: TObject; const StartFrom: string; Direction, InsertAt: integer); override;
  procedure promptChange(Sender: TObject); override;
public
  layout: tLayout;
  procedure populateComponent;
  procedure setDefaultValue;
end;

procedure populateProviderLookup(editObject: vEditObject; name: string);
procedure updateSiteLookUp(data: string; routeEditObject: vEditObject; layout: tLayout);
procedure updateExpAndManuf(data: string; layout: tLayout);

implementation


{ editObject }

procedure vEditObject.loadUsers(control: TControl; const StartFrom: string;
  Direction, InsertAt: Integer; providerOnly: boolean);
var
  Dest: TStrings;
begin
  Dest := TSTringList.Create;
  try
    try
      if not providerOnly then
        setSubSetOfPersons(Dest,StartFrom,Direction)
      else
        setSubSetOfProviders(Dest,StartFrom,Direction)
    finally
    end;
    (control as TORComboBox).ForDataUse(Dest);
  finally
    Dest.Free;
  end;
end;

procedure vEditObject.onNeedData(sender: TObject; const StartFrom: string;
  Direction, InsertAt: integer);
var
provider: boolean;
begin
 if name = 'ORDERBY' then provider := true
 else provider := false;
 loadUsers((editComponent as TORComboBox), startFrom, direction, insertAt, provider);
end;

procedure vEditObject.populateComponent;
var
 cbo: TORCombobox;
 i: integer;
begin
  if name = 'ADMIN ROUTE' then
    begin
      if self.dataList = nil then exit;
      if self.dataList.count = 0 then exit;
      if (editComponent is TORComboBox) then
        begin
          cbo := (editComponent as TORCombobox);
          for i := 0 to dataList.Count - 1 do
            begin
              if Piece(dataList.Strings[i], u, 1) <> 'SITE' then
                cbo.Items.Add(dataList.Strings[i]);
            end;
        end;
    end
    else
    inherited;
end;

procedure vEditObject.promptChange(Sender: TObject);
var
  idx: integer;
  temp: string;
  cbo: TORComboBox;
begin
  self.intVal := '';
  self.extVal := '';
  if self.name = 'ADMIN ROUTE' then
    begin
      cbo := (Sender as TORComboBox);
      idx := cbo.ItemIndex;
      if idx = -1 then exit;
      temp := cbo.Items.Strings[idx];
      if temp = '' then exit;
      intVal := Piece(temp, u, 1);
      extVal := Piece(temp, u, 2);
      updateSiteLookUp(temp, self, layout);
      exit;
    end
  else if (self.name = 'LOT NUMBER') and ((Sender is TORComboBox)) then
    begin
      cbo := (Sender as TORComboBox);
      idx := cbo.ItemIndex;
      if idx = -1 then exit;
      temp := cbo.Items.Strings[idx];
      if temp = '' then exit;
      intVal := Piece(temp, u, 1);
      extVal := Piece(temp, u, 2);
      updateExpAndManuf(temp, layout);
      exit;
    end
  else inherited;
end;
procedure vEditObject.setDefaultValue;
begin
 inherited;
end;

procedure populateProviderLookup(editObject: vEditObject; name: string);
var
idx: integer;
begin
  (editObject.editComponent as TORComboBox).InitLongList(name);
  idx := (editObject.editComponent as TORComboBox).Items.IndexOf(name);
  if idx > -1 then
    begin
      (editObject.editComponent as TORComboBox).ItemIndex := idx;
      editObject.intVal := Piece((editObject.editComponent as TORComboBox).Items.Strings[idx],u,1);
      editObject.extVal := (editObject.editComponent as TORComboBox).Text;
    end;
end;

procedure updateSiteLookUp(data: string; routeEditObject: vEditObject; layout: tLayout);
var
idx, i, k, siteIdx: integer;
locText: string;
items: TStrings;
siteNone, locFound: boolean;
layoutControl: tLayoutControl;
editObject: vEditObject;
cboSite: TORCombobox;
begin
  idx := routeEditObject.dataList.IndexOf(data);
  if idx = -1 then exit;
  siteIdx := Layout.controls.IndexOf('ADMIN SITE');
  layoutControl := tLayoutControl(Layout.controls.Objects[siteIdx]);
  editObject := vEditObject(layoutControl.uiControl);
  cboSite := (editObject.editComponent as TORCombobox);
  siteNone := false;
    if cboSite.Items.Count > 0 then
      begin
        cboSite.ItemIndex := -1;
        cboSite.Text := '';
        cboSite.Items.Clear;
      end;
  items := TStringList.Create;
  try
  inc(idx);
  for i := idx to routeEditObject.dataList.Count -1 do
    begin
      if (Piece(routeEditObject.dataList.Strings[i], u, 1) <> 'SITE') then break;
      if (Piece(routeEditObject.dataList.Strings[i], u, 2) = 'ALL') then continue;
//      if Piece(routeEditObject.dataList.Strings[i], u, 2) = 'ALL' then exit;
      if Piece(routeEditObject.dataList.Strings[i], u, 2) = 'NONE' then
        begin
          siteNone := true;
          break;
        end;
      items.Add(Piece(routeEditObject.dataList.Strings[i], u, 2));
    end;
    if siteNone then cboSite.Enabled
    else
      begin
        FastAssign(editObject.dataList, cboSite.items);
        idx := 0;
        for i := 0 to items.Count - 1 do
        begin
          LocText := Piece(items[i], U, 1);
          if LocText <> '' then
            begin
              if (LocText <> '0') and (IntToStr(StrToIntDef(LocText, 0)) = LocText) then
                begin
                  LocFound := FALSE;
                  for k := 0 to cboSite.items.Count - 1 do
                    begin
                      if Piece(cboSite.Items[k], U, 1) = LocText then
                        begin
                          LocText := cboSite.Items[k];
                          LocFound := TRUE;
                          break;
                        end;
                    end;
                  if not LocFound then LocText := '';
                end
              else
                begin
                  if StrToIntDef(Piece(LocText, U, 1), -1) = -1 then LocText := '0^' + LocText;
                end;
              if LocText <> '' then
                begin
                  cboSite.items.insert(idx, LocText);
                  inc(idx);
                end;
            end;
        end;
        if idx > 0 then
          begin
            cboSite.Items.insert(idx, '-1' + LLS_LINE);
            cboSite.Items.insert(idx + 1, '-1' + LLS_SPACE);
          end;
      end;

  finally
    FreeAndNil(items);
  end;

end;


procedure updateExpAndManuf(data: string; layout: tLayout);
var
idx: integer;
layoutControl: tLayoutControl;
editObject: vEditObject;
dataLbl: TStaticText;
begin
  idx := Layout.controls.IndexOf('EXPIRATION DATE');
  if idx > -1 then
  begin
    layoutControl := tLayoutControl(Layout.controls.Objects[idx]);
    editObject := vEditObject(layoutControl.uiControl);
    dataLbl := (editObject.editComponent as TStaticText);
    dataLbl.caption := Piece(data, U, 4);
    editObject.intVal := dataLbl.Caption;
    editObject.extVal := dataLbl.Caption;
  end;
  idx := Layout.controls.IndexOf('MANUFACTURER');
  if idx > -1 then
  begin
    layoutControl := tLayoutControl(Layout.controls.Objects[idx]);
    editObject := vEditObject(layoutControl.uiControl);
    dataLbl := (editObject.editComponent as TStaticText);
    dataLbl.caption := Piece(data, U, 3);
    editObject.intVal := dataLbl.Caption;
    editObject.extVal := dataLbl.Caption;
  end;
end;

end.
